/*
 *  SPI.C
 *   Created on: Feb 12, 2016
 *      Author: B52321
 *
 */
#include "SKEAZ1284.h"
#include "SPI.h"

char SPI_init(SPI_Type *pSPI, char mode){

	if(pSPI == SPI0){
		SIM_SCGC |=SIM_SCGC_SPI0_MASK ;          /* enable SPI clock */
	} else if (pSPI == SPI1){
		SIM_SCGC |=SIM_SCGC_SPI1_MASK ;          /* enable SPI clock */
	}


	pSPI->C1 |= SPI_C1_SPE_MASK; 			   /* SPI System enable */

	if(mode==MASTER){						   /* if  Master mode selected */
		pSPI->C1 |= SPI_C1_MSTR_MASK;  		   /* Master mode enable */
	}
	pSPI->C1 |= SPI_C1_CPHA_MASK;			   /* the first cycle of a data transfer occurs at fist edge */
	pSPI->C1 |= SPI_C1_SSOE_MASK; 			   /* Slave select output enable */
	pSPI->C2 |= SPI_C2_MODFEN_MASK;
	pSPI->BR = SPI_BR_SPPR(0)|SPI_BR_SPR(0);  /* 500kb/s = 20Mhz/((SPPR+1)*(2^(SPR +1))) */
	return mode;							   /* 500kHz = (20MHz/(5*(2^(3))))  */
}

void SPI_transmit(SPI_Type *pSPI, char data){              /* send SPI data */

	while(!(pSPI->S & SPI_S_SPTEF_MASK));	   /* wait for transmit buffer empty */
	pSPI->D = data;						   /* write SPI buffer */
}

char SPI_read(SPI_Type *pSPI){						 /*wait for receive value in SPI buffer */

	char data;
	while(!(pSPI->S & SPI_S_SPRF_MASK));			/* Wait for data from master buffer */
	data = pSPI->D ;								/* Read SPI buffer */

	return data;
}

char SPI_transfer(SPI_Type *pSPI, char data){       /* Send/receive SPI data */

	while(!(pSPI->S&SPI_S_SPTEF_MASK));	   			/* wait for transmit buffer empty */
	pSPI->D = data;						   			/* write SPI buffer */
	return SPI_read(pSPI);
}
